
--------------------------- General Geppetto UI -----------------------------------

struct NumFramesSpinnerCallback
(
	fn OnChanged iValue = 
	(
		pop.numFrames = iValue
		updatetoolbarbuttons() -- for typed in values
	),
	fn onButtonUp iValue =
	(
		updatetoolbarbuttons()
	),
	fn getValue =
	(
		pop.numFrames
	)
)

struct SeatFemalePctSpinnerCallback
(
	fn OnChanged fValue = 
	(
		pop.seatFemalePct = fValue
		updatetoolbarbuttons() -- for typed in values
	),
	fn onButtonUp fValue =
	(
		updatetoolbarbuttons()
	),
	fn getValue =
	(
		pop.seatFemalePct
	)
)

fn popSkinCharSelected =
(
	for i in selection do
		if classof i == popSkinObject
		then return true
	return false
)

--------------------------- Crowd Area Draw Tools -----------------------------------

fn CrowdAreaToolToggle toolType =
(
	currentTool = CrowdAreaGetActiveTool()
	if (currentTool != 0) then --End any active tool
	(
		max modify mode
		CrowdAreaEnd()
		PBEndTrack()
		if (currentTool != toolType) do --Start another tool
		(
			CrowdAreaSetup toolType
			PBStartTrack CrowdAreaDrawing 1
--			CrowdAreaEnd()
		)
	)
	else --Start tool
	(
		CrowdAreaSetup toolType
		PBStartTrack CrowdAreaDrawing 1
--		CrowdAreaEnd()
	)
)

fn CrowdAreaEndTools =
(
	CrowdAreaEnd()
	PBEndTrack()
)

struct CrowdAreaBrushSizeSpinnerCallback
(
	fn OnChanged iValue = 
	(
		CrowdAreaSetBrushSize iValue
	),
	fn getValue =
	(
		CrowdAreaGetBrushSize()
	)
)

struct CrowdAreaBrushSizePathSpinnerCallback
(
	fn OnChanged iValue = 
	(
		CrowdAreaSetBrushSizePath iValue
	),
	fn getValue =
	(
		CrowdAreaGetBrushSizePath()
	)
)

struct CrowdAreaCircleSidesSpinnerCallback
(
	fn OnChanged iValue = 
	(
		CrowdAreaSetCircleSides iValue
	),
	fn getValue =
	(
		CrowdAreaGetCircleSides()
	)
)


--------------------------- Called by Orchestrator Actions -----------------------------------

fn ActionCreateFlow =
(
	if (CrowdAreaGetActiveTool() == 0) then
	(
		subobjectlevel = 0
		CrowdAreaSetup 6
		PBStartTrack CrowdPathDrawing 1
--		CrowdAreaEnd()
	)
	else
	(
		currentTool = CrowdAreaGetActiveTool()
		CrowdAreaEnd()
		PBEndTrack()
		if (currentTool != 6) do
		(
			subobjectlevel = 0
			CrowdAreaSetup 6
			PBStartTrack CrowdPathDrawing 1
--			CrowdAreaEnd()
		)
	)
)

fn ActionEditFlow =
(
	if (CrowdAreaGetActiveTool() != 0) do
	(
		CrowdAreaEnd()
		PBEndTrack()
	)
	if (subobjectlevel == 1 or subobjectlevel == 2) then
	(
		subobjectlevel = 0
	)
	else
	(
		max modify mode
		subobjectlevel = 1
	)
)

fn ActionExtendFlow =
(
	currentTool = CrowdAreaGetActiveTool()
	CrowdAreaEnd()
	PBEndTrack()
	if (currentTool != 7) do
	(
		CrowdAreaSetup 7
		PBStartTrack CrowdPathExtend
		--CrowdAreaEnd()
		--CrowdDoRestartPathTool() --If user clicked endpoint, start path drawing tool
	)
)

fn ActionIdleAddMode =
(
	if (CrowdAreaGetAddMode() == 1) then
	(
		CrowdAreaSetAddMode 0
	)
	else
	(
		CrowdAreaSetAddMode 1
	)
	updateToolbarButtons()
)

fn ActionIdleSubtractMode =
(
	if (CrowdAreaGetAddMode() == 2) then
	(
		CrowdAreaSetAddMode 0
	)
	else
	(
		CrowdAreaSetAddMode 2
	)
	updateToolbarButtons()
)
